<?php
header('Content-Type: application/json');
include '../includes/db.php';

// সার্ভার HTTPS ব্যবহার করলে 'https' চেক করা হচ্ছে
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$base_url = $protocol . $_SERVER['SERVER_NAME'] . "/admin_panel/";

$response = array();
$streams = array();

$sql = "SELECT id, title, stream_url, thumbnail_path FROM live_streams ORDER BY id DESC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $stream_item = array(
            'id' => $row['id'],
            'title' => $row['title'],
            'stream_url' => $row['stream_url'],
            // থাম্বনেইল URL যোগ করা হয়েছে
            'thumbnail_url' => !empty($row['thumbnail_path']) ? $base_url . $row['thumbnail_path'] : null
        );
        array_push($streams, $stream_item);
    }
    $response['status'] = 'success';
    $response['streams'] = $streams;
} else {
    $response['status'] = 'error';
    $response['message'] = 'No streams found';
}

echo json_encode($response);
$conn->close();
?>